/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.component.ComponentsService;
import org.sonarqube.ws.client.issue.IssuesService;
import org.sonarqube.ws.client.permission.PermissionsService;
import org.sonarqube.ws.client.qualitygate.QualityGatesService;
import org.sonarqube.ws.client.qualityprofile.QualityProfilesService;
import org.sonarqube.ws.client.usertoken.UserTokensService;

public class HttpWsClient
implements WsClient {
    private final PermissionsService permissionsService;
    private final ComponentsService componentsService;
    private final QualityProfilesService qualityProfilesService;
    private final IssuesService issuesService;
    private final UserTokensService userTokensService;
    private final QualityGatesService qualityGatesService;
    private final WsConnector wsConnector;

    public HttpWsClient(WsConnector wsConnector) {
        this.wsConnector = wsConnector;
        this.permissionsService = new PermissionsService(wsConnector);
        this.componentsService = new ComponentsService(wsConnector);
        this.qualityProfilesService = new QualityProfilesService(wsConnector);
        this.issuesService = new IssuesService(wsConnector);
        this.userTokensService = new UserTokensService(wsConnector);
        this.qualityGatesService = new QualityGatesService(wsConnector);
    }

    @Override
    public WsConnector wsConnector() {
        return this.wsConnector;
    }

    @Override
    public PermissionsService permissions() {
        return this.permissionsService;
    }

    @Override
    public ComponentsService components() {
        return this.componentsService;
    }

    @Override
    public QualityProfilesService qualityProfiles() {
        return this.qualityProfilesService;
    }

    @Override
    public IssuesService issues() {
        return this.issuesService;
    }

    @Override
    public UserTokensService userTokens() {
        return this.userTokensService;
    }

    @Override
    public QualityGatesService qualityGates() {
        return this.qualityGatesService;
    }
}

